function [output] = join_verts(dir_tmp,norm_prop)
%This function takes asks you to open a bunch of vertex files and it will
%join then all together as one file.  Will work for not vertices files as
%well just make sure they have the same number of columns. Files must be of
%the formate s6s7(punct)thekdj.csv or s6s7(punct)thekdj(punct)46573.csv
%Synatax:   [data] = join_verts();
%Input:     dir_tmp = the directory of interest
%           norm_prop = normalize the dataset, useful for properties,
%               default = 0
%Output:    output = the joined data set. Sturucture with fields: data = the
%               data from each file and name = the filenames in order.

if nargin==0||isempty(dir_tmp)
    prompt_box('title','Open File Location','prompt1','Select the vertex lists you want to combine.','position','center');
    pause(0.25);
    %     [filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.xlsx','Excel 2007 files (*.xlsx)';...
    %         '*.xls','Excel files (*.xls)';'*.*','All Files';},...
    %         'Open Stack','Multiselect','on');
    dir_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end
if nargin<2
    norm_prop = 0;   %off
end
%Now sort through the directory and find the
[filenames,names] = dir_sort(dir_tmp);
%Now open each file append and save
mkdir(dir_tmp,'joined');
if norm_prop
    mkdir(dir_tmp,'joined_quantile');
    mkdir(dir_tmp,'joined_median');
end
for j = 1:size(filenames,2) %go through the file sets
    filename_tmp = filenames{j};
    data = [];  %initialize/reset
    verti_tmp = [];
    if norm_prop
        qdata = [];  %initialize/reset
        mdata = [];  %initialize/reset
    end
    for i = 1:size(filename_tmp,1)      %now append the files
        %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
        try     %file could be empty
            verti_tmp = single(dlmread([dir_tmp,filesep,filename_tmp(i,:)],',',1,0));
        end
        data = vertcat(data,verti_tmp);       %join all the opened data together
        if norm_prop && ~isempty(verti_tmp)
            mverti_tmp = manorm(verti_tmp,'Method','median','LogData',1);
            qverti_tmp = quantilenormloco(verti_tmp);
            qdata = vertcat(qdata,qverti_tmp);  %store the data in a structure
            mdata = vertcat(mdata,mverti_tmp);  %store the data in a structure
        end
    end
    if ~isempty(data)   %make sure there is data first
        %remove the NaN
        data(isnan(data(:,1)),:) = [];
        %now save out the data file
        dataout = dataset(data);
        sav2csv(dataout,[names{j,1},'_',num2str(size(data,1)),'.csv'],[dir_tmp,'\joined']);
        output(j).data = data;
        if norm_prop
            qdata(isnan(qdata(:,1)),:) = [];
            qdataout = dataset(qdata);
            sav2csv(qdataout,[names{j,1},'_',num2str(size(qdata,1)),'.csv'],[dir_tmp,'\joined_quantile']);
            output(j).qdata = qdata;
            mdata(isnan(mdata(:,1)),:) = [];
            mdataout = dataset(mdata);
            sav2csv(mdataout,[names{j,1},'_',num2str(size(mdata,1)),'.csv'],[dir_tmp,'\joined_median']);
            output(j).mdata = mdata;
        end
    end
end
output(1).names = names;

%-----------------------------------------------------------------------------------------------------------------------------
function [filenames_out,uq_names] = dir_sort(dir_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);
%filename_tmp = filename_tmp(3:end,:);
for i = 1:size(filenames,2)      %step through each filename and pull the wanted word
    filename_tmp = filenames{i};
    strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
    strmask2 = filename_tmp=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(filename_tmp,'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    %if strcmp('csv',filename_tmp(i,y(end)+1:y(end)+3))  %we only care about the csv files for now.
%     if size(y,2)<=3
%         tmp = filename_tmp(1,y(end-1)+1:y(end)-1);    %create an array of the words
%         %now lets consider the vertices case
%         if ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
%             tmp = filename_tmp(1,y(end-2)+1:y(end-1)-1);    %create an array of the words
%         end
%         f_tmp{i,:} = tmp;
%     else    %too complicated take the whole thing
%         tmp = filename_tmp(1,y(end-1)+1:y(end)-1);    %create an array of the words
%         %now lets consider the vertices case
%         if ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
%             tmp = filename_tmp(1,y(1)+1:y(end-1)-1);    %create an array of the words
%         else    %not vertices file or no numbers at very end
%             tmp = filename_tmp(1,y(1)+1:y(end)-1);
%         end
%         f_tmp{i,:} = tmp;
%     end
    %end
    a = 1;  %initiate
    b = 0;
    tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    while ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        b = b+1;
        if size(y,2)-a==0
            break
        end
        tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    end
    %now do the same for the front
    a = 0;
    tmp = filename_tmp(1,1:y(1+a)-1);
    while ~isempty(str2num(tmp))&&size(y,2)~=a+1   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        tmp = filename_tmp(1,1:y(1+a)-1);    %create an array of the words
    end
    if a==0
        f_tmp{i,:} = filename_tmp(1,1:y(end-b)-1);
    else
        f_tmp{i,:} = filename_tmp(1,y(a)+1:y(end-b)-1);
    end
end
uq_names = unique(f_tmp);    %how many unique words are there
%make sure there are no duplicates with different cases
idx = [];   %index of removal
for l = 1:size(uq_names,1)      %step through unique names
    for m = 1:size(uq_names,1)     %step through the all file names
        if strcmpi(uq_names(l,:),uq_names(m,:)) && l<m    %if there is a match (case insensitive now) Remove
            idx = [idx;m];  %remove
        end
    end
end 
uq_names(unique(idx),:) = [];    %remove
for j = 1:size(uq_names,1)      %step through unique names
    tmp = [];
    for k = 1:size(f_tmp,1)     %step through the all file names
        if strcmpi(uq_names(j,:),f_tmp(k,:)) %if there is a match (case insensitive now)
            tmp = vertcat(tmp,filenames(k));  %put it in the current file names temp
        end
    end
    filenames_out{j} = char(tmp);
end            
%-----------------------------------------------------------------------------------------------------------------------------
function [norm_data] = quantilenormloco(data)
%This little function makes sure quantile normalization works
%first check to make sure the input data does not have empty columns
data_chk = isnan(data);
chk_data = sum(data_chk,1);     %beging selection process for empty or singleton data columns
chk_data = abs(chk_data-size(data,1));  %nan items calculated
idx = find(chk_data<=1);    %index of the empty or singleton columns
if ~isempty(idx)     %there is an empty or singleton column, fix that
    norm_data = data;     %copy original matrix context for reconstitution
    reconidx = find(chk_data>1);   %index of reconstitution
    data(:,idx) = [];       %remove temporarily
    if ~isempty(data)   %if all is gone, don't do it
        norm_tmp = quantilenorm(data,'Median',1);     %normalize
        norm_data(:,reconidx) = norm_tmp;   %reconstituted in original contex
    end
else    %no problems go on
    norm_data = quantilenorm(data,'Median',1);
end